-- RadarBars 2.0
-- as originally seen (v1.0) in dubaiOne.

-- okay this is now a per-player basis.
-- This should help clean the code up a lot.
local Player = ...
assert(Player);

local rb = Def.ActorFrame{
	Name="RadarBars"
};

--[[ TODO: custom messages for stuff. 1995 EX starts. ]]

local barHeight = 8; -- this is mainly used for spacing issues.
local barMaxWidth = 128; -- maximum width for bar.
local offset = barHeight+2; -- vertical offset between bars
local rv; -- for storing the RadarValues.

-- pre-runthrough setup of some very important junk:
local Selection; -- either song or course.
local bIsCourseMode = GAMESTATE:IsCourseMode();
local StepsOrTrail;

for idx, cat in pairs(RadarCategory) do
	if idx < 6 then -- only do Stream, Voltage, Air, Freeze, Chaos Emeralds
		rb[#rb+1] = Def.ActorFrame{
			-- bar BG
			Def.Quad{
				InitCommand=cmd(y,((idx-1)*offset);zoomto,barMaxWidth,barHeight;horizalign,left;diffuse,color("0,0,0,0.25"));
			};
			
			-- the bar itself is dynamic and therefore needs more code.
			LoadActor("_rb")..{
				InitCommand=cmd(y,((idx-1)*offset);horizalign,left;diffuse,PlayerColor(Player));
				BeginCommand=cmd(playcommand,"Set");
				SetCommand=function(self)
					-- due to a visual display bug, you have to stop effects
					-- here for them to match up.
					self:stopeffect();
					
					-- here's the fun part.
					local width = 0; -- this gets changed.
					
					if bIsCourseMode then
						Selection = GAMESTATE:GetCurrentCourse();
						StepsOrTrail = GAMESTATE:GetCurrentTrail(Player);
					else
						Selection = GAMESTATE:GetCurrentSong();
						StepsOrTrail = GAMESTATE:GetCurrentSteps(Player);
					end;
					
					if not Selection then width = 0;
					else
						-- we have a selection.
						-- Make sure there's something to grab values from.
						if not StepsOrTrail then width = 0;
						else
							rv = StepsOrTrail:GetRadarValues(Player);
							-- the graphic is 2px wide for whatever reason
							width = rv:GetValue(cat) * (barMaxWidth/2);
						end;
					end;
					
					-- glow super insane junk
					if rv and rv:GetValue(cat) >= 0.99 then
						self:glowshift();
						self:effectcolor1( color("1,1,1,0.25") );
						self:effectcolor2( color("1,1,1,0.5") );
					else
						self:stopeffect();
					end;
					
					self:finishtweening();
					self:zoomx(width);
				end;
				-- generic song/course changes
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
				-- player based changes
				CurrentStepsP1ChangedMessageCommand=function(self)
					if Player == PLAYER_1 then self:playcommand("Set"); end;
				end;
				CurrentTrailP1ChangedMessageCommand=function(self)
					if Player == PLAYER_1 then self:playcommand("Set"); end;
				end;
				CurrentStepsP2ChangedMessageCommand=function(self)
					if Player == PLAYER_2 then self:playcommand("Set"); end;
				end;
				CurrentTrailP2ChangedMessageCommand=function(self)
					if Player == PLAYER_2 then self:playcommand("Set"); end;
				end;
			};
			
			-- labels
			LoadFont("_pf tempesta seven 8px")..{
				Text=THEME:GetString("RadarCategories",cat);
				InitCommand=cmd(x,-2;y,((idx-1)*offset);shadowlength,1;horizalign,right;PixelFont);
			};
			
			-- hey I know, let's add a DEBUGGING feature!!! YEAH!!
			LoadFont("_pf tempesta seven 8px")..{
				InitCommand=cmd(x,barMaxWidth;y,((idx-1)*offset);shadowlength,1;horizalign,right;PixelFont;diffusealpha,0.8);
				BeginCommand=cmd(playcommand,"Set");
				-- duplicated code, I must be very proud of myself
				SetCommand=function(self)
					local percent = 0.0;
					
					if bIsCourseMode then
						Selection = GAMESTATE:GetCurrentCourse();
						StepsOrTrail = GAMESTATE:GetCurrentTrail(Player);
					else
						Selection = GAMESTATE:GetCurrentSong();
						StepsOrTrail = GAMESTATE:GetCurrentSteps(Player);
					end;
					
					if not Selection then percent = 0.0;
					else
						-- we have a selection.
						-- Make sure there's something to grab values from.
						if not StepsOrTrail then percent = 0.0;
						else
							rv = StepsOrTrail:GetRadarValues(Player);
							percent = rv:GetValue(cat)*100;
						end;
					end;
					--self:settext( string.format("%.2f",percent) );
					self:settext( math.ceil(percent) );
					-- SPECIAL BULLSHIT
					if Selection and Selection:GetDisplayFullTitle() == "1995 EX" then
						if cat == 'RadarCategory_Stream' or cat == 'RadarCategory_Chaos' then
							self:settext("GOD DAMNIT RENARD");
						end;
					end;
					if Selection and Selection:GetDisplayFullTitle() == "Dash Hopes II" then
						self:settext("why even try?");
					end;
				end;
				-- generic song/course changes
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
				-- player based changes
				CurrentStepsP1ChangedMessageCommand=function(self)
					if Player == PLAYER_1 then self:playcommand("Set"); end;
				end;
				CurrentTrailP1ChangedMessageCommand=function(self)
					if Player == PLAYER_1 then self:playcommand("Set"); end;
				end;
				CurrentStepsP2ChangedMessageCommand=function(self)
					if Player == PLAYER_2 then self:playcommand("Set"); end;
				end;
				CurrentTrailP2ChangedMessageCommand=function(self)
					if Player == PLAYER_2 then self:playcommand("Set"); end;
				end;
			};
		};
	end;
end;

return rb;